/*
	Month Calendar - A Monthly Calendar with Week Numbers
	Copyright © 2005-2008 Harry Whitfield

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this program; if not, write to the Free
	Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
	MA  02110-1301  USA
	
	Month Calendar - version 2.8
	29 August, 2008
	Copyright © 2005-2008 Harry Whitfield
	mailto:g6auc@arrl.net
*/

function doCommand(command)
{
	lprint('command: ' + command);
	var result = runCommand(command);
	lprint('result:  ' + result);
	return result;
}

function addModes(mode1, mode2)		// modes are 4 digit octal
{
	mode1 = mode1.split("");
	mode2 = mode2.split("");
	var result = "";
	for (var i = 0; i < 4; i += 1) { result += String(Number(mode1[i]) | Number(mode2[i])); }
	return result;
}

function escapePath(path) { return path.replace(/([\W])/g,'\\$1'); }

// calls used only on the Macintosh - never have been in Unix Utils
function getFileInfo(path) { return doCommand('file ' + escapePath(path)); }

filesystem.makeDirectory = function(path)  { return filesystem.createDirectory(path); };
filesystem.unixRM = function(path) { return filesystem.remove(path); };

// calls to compensate for loss of Unix Utils on Windows

filesystem.removeDirectoryContents = function(path)	// Widget Tester and Month Calendar only
{
	if (! filesystem.isDirectory(path)) { return false; }
	var result = true;
	var files  =  filesystem.getDirectoryContents(path, false);
	for (var i = 0; i < files.length; i += 1) { result = result && filesystem.remove(path + '/' + files[i]); }
	return result;
};

function theURL(url, outputFile, referer)
{
	var myUrl = new URL();
	if (outputFile !== "") { myUrl.outputFile = outputFile; }
	if (referer    !== "") { myUrl.setRequestHeader( "Referer", referer ); }
	var result = myUrl.fetch(url);
	var resp = myUrl.response;
	lprint('theURL:resp=' + resp);
	if (outputFile !== "") { lprint('theURL:result=' + result); }
	var OK = ((resp == 200) || (resp === 0));	// resp === 0 for local files
	if (outputFile !== "")
	{
		if (OK) { return ""; } else { return 'Cannot fetch "' + url + '". HTTP Error code ' + resp + '.'; }
	}
	else
	{
		if (OK) { return result; } else { return ""; }
	}
}


// Fix for text tooltip bug on K 4.0.x  9 May, 2007 in version 2.0.5

function countLines(text)
{
	var n = 0;
	for (var i = 0; i < text.length; i += 1) { if (text[i] == "\n") { n += 1; } }
	return n;
}

function sizeOf(text, font, size)
{
	var realLength;
	var maxLength = 44;
	var multipier = 1.6;
	var lines = countLines(text);
	if (lines === 0)
	{
		realLength = Math.ceil(multipier*stringWidth(text, font, "", size) / size);
		if (realLength <= maxLength) { return [realLength + 1, 1]; }
	}
	return [maxLength, lines + 1];
}

function makeTooltip(obj)
{
	var text = obj.myTooltip;
	var font = "Lucida Grande";
	var size = 11;
	var theSize = sizeOf(text, font, size);
	var txt       = new TextArea();
	txt.hOffset   = obj.hOffset;						// system.event.hOffset;
	txt.vOffset   = obj.vOffset + (obj.height>>2) + 4;	//system.event.vOffset + 20;
	txt.columns   = theSize[0];
	txt.lines     = theSize[1];
	txt.color     = "#000000";
	txt.bgColor   = "#F6F7C1";
	txt.opacity   = 255;
	txt.bgOpacity = 255;
	txt.data      = text;
	txt.font      = font;
	txt.size      = size;
	txt.editable  = false;
	txt.scrollbar = false;
	txt.zOrder = 100;
	return txt;
}

var tooltip = null;

function displayTooltip(i, j)
{
	removeTooltip();
	var obj;
	if (i < 0) { obj = Head; } else { obj = T[i][j]; }
	if (obj.myTooltip !== "")
	{
		tooltip = makeTooltip(obj);
		main_window.width  = main_frame.width = mainFrameWidth  + tooltip.width;
		main_window.height  = main_frame.height = mainFrameHeight  + tooltip.height;
		main_frame.appendChild(tooltip);
		tooltipTimer.ticking = true;
	}
}

function removeTooltip()
{
	tooltipTimer.ticking = false;
	if (tooltip !== null)
	{
		main_frame.removeChild(tooltip);
		tooltip = null;
		main_window.width  = main_frame.width  = mainFrameWidth;
		main_window.height  = main_frame.height  = mainFrameHeight;
	}
}
